//	CFolderPas.h

#ifndef _H_CFolderPas
#define _H_CFolderPas

#include "CFolder.h"
#include "PasStructs.h"

typedef		OSErr	Pas_ForEachEntryCB(
	CFolderPas			*thiz, 
	Pas_DirEntry		*entry, 
	Pas_BlockNum		blockNum, 
	Pas_EntryIndex		entryIndex, 
	Boolean				*done, 
	void				*data);

class CFolderPas : public CFolder {

	public:	
	
	OSErr	IFolderPas(
		CDiskPas			*cDiskPas, 
		Pas_BlockNum		blockNum);

	virtual	void	Dispose(void);
	
	OSErr			Pas_ForEachEntry(
		Pas_ForEachEntryCB	Pas_ForEachUserCB, 
		void				*data);

	//	static
	static	OSErr	Pas_MakeNewEntryCB(
		CFolderPas			*thiz, 
		Pas_DirEntry		*entry, 
		Pas_BlockNum		blockNum, 
		Pas_EntryIndex		entryIndex, 
		Boolean				*done, 
		void				*data);

	OSErr			Pas_MakeNewEntry(
		Pas_DirEntry		*entry, 
		Pas_BlockNum		blockNum, 
		Pas_EntryIndex		entryIndex, 	//	within cur sector
		Pas_EntryIndex		directoryIndex, //	within entire catalog
		CEntry				**newEntry0);

	Boolean		GetUniqueName(char *fileName);
	OSErr		NewFile(Boolean isFolder, CEntry **entryH);
	OSErr		Pas_DeleteEntry(Pas_EntryIndex entryIndex);

	Pas_DirEntry	*GetEntry(Pas_BlockNum blockNum, Pas_EntryIndex entryIndex);
	Pas_DirEntry	*GetMyEntry(void);
	virtual	OSErr		Delete(Boolean warnB = FALSE, CDialogCopy *copyP0 = NULL);
	virtual	OSErr		UnDelete(Boolean recursiveB = FALSE, CDialogCopy *copyP0 = NULL);

	private:
	typedef CFolder _inherited;
};


#endif
